<?php
class ControllerCommonHeader extends Controller {
	public function index() {
		// Analytics
		$this->load->model('setting/extension');

		$data['analytics'] = array();

		$analytics = $this->model_setting_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get('analytics_' . $analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('extension/analytics/' . $analytic['code'], $this->config->get('analytics_' . $analytic['code'] . '_status'));
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}


		/* NeoSeo Firestore BEGIN */
		$this->load->model('extension/module/neoseo_menu');
        $current_theme = trim($this->config->get('config_theme'));

		$menu_status = $this->config->get('theme_' . $current_theme . '_menu');

		if ($menu_status) {
			$data['top_menu'] = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_top_menu_id'));
		}

		$data['phone_1'] = $this->config->get('theme_' . $current_theme . '_top_phone_1');
		$data['phone_2'] = $this->config->get('theme_' . $current_theme . '_top_phone_2');
		$data['social'] = html_entity_decode($this->config->get('theme_' . $current_theme . '_top_social_link'));
		$data['messenger'] = html_entity_decode($this->config->get('theme_' . $current_theme . '_top_messenger_link'));
		/* NeoSeo Firestore END */
		$data['title'] = $this->document->getTitle();

		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();

		/* NeoSeo Popup Cart - begin */
		//if(!$this->config->is_mobile())
		{
			$this->document->addScript('catalog/view/javascript/neoseo_popup_cart.js');
		}
		/* NeoSeo Popup Cart - end */

		/* NeoSeo QuickOrder - begin */
		$this->document->addScript('catalog/view/javascript/neoseo_quick_order.js');
		$this->document->addScript('catalog/view/javascript/jquery/jquery.validation/jquery.validate.js');
		$this->document->addScript('catalog/view/javascript/jquery/jquery.maskedinput.js');
		$this->document->addScript('catalog/view/javascript/jquery/jquery.validation/additional-methods.js');
		$lang_code = isset($this->session->data['language']) ? $this->session->data['language'] : $this->config->get('config_language');
		if($lang_code === 'uk-ua' || $lang_code === 'ua-uk') {
			$this->document->addScript('catalog/view/javascript/jquery/jquery.validation/localization/messages_uk.js');
		} else if ($lang_code == 'ru-ru'){
			$this->document->addScript('catalog/view/javascript/jquery/jquery.validation/localization/messages_ru.js');
		}
		/* NeoSeo QuickOrder - end */
		/* NeoSeo Smart Search - begin */
        if ($this->config->get("neoseo_smart_search_status") == 1) {
		    $this->document->addScript('catalog/view/javascript/neoseo_smart_search.js');
		}
        /* NeoSeo Smart Search - end */
		$data['scripts'] = $this->document->getScripts('header');
		/* NeoSeo Filter - start */
        $data['noindex'] = $this->document->nsf_isNoindex();
        /* NeoSeo Filter - end */
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {

		/* NeoSeo Firestore BEGIN */
		$data['logo_wh'] = getimagesize(DIR_IMAGE . $this->config->get('config_logo'));
		/* NeoSeo Firestore END */
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}

		$this->load->language('common/header');
		/* NeoSeo Smart Search - begin */
        if ($this->config->get("neoseo_smart_search_status") == 1) {
		    $this->load->language('extension/module/neoseo_smart_search');
		}
		/* NeoSeo Smart Search - end */

		// Wishlist
		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');

                /* NeoSeo Firestore BEGIN */
                $data['total_wishlist'] = $this->model_account_wishlist->getTotalWishlist();
                /* NeoSeo Firestore END */

			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
		} else {
			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		}

		$data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', true), $this->customer->getFirstName(), $this->url->link('account/logout', '', true));
		
		$data['home'] = $this->url->link('common/home');
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['logged'] = $this->customer->isLogged();
		$data['account'] = $this->url->link('account/account', '', true);
		$data['register'] = $this->url->link('account/register', '', true);
		$data['login'] = $this->url->link('account/login', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['transaction'] = $this->url->link('account/transaction', '', true);
		$data['download'] = $this->url->link('account/download', '', true);
		$data['logout'] = $this->url->link('account/logout', '', true);
		$data['shopping_cart'] = $this->url->link('checkout/cart');
		$data['checkout'] = $this->url->link('checkout/checkout', '', true);
		$data['contact'] = $this->url->link('information/contact');
		$data['telephone'] = $this->config->get('config_telephone');
		
		$data['language'] = $this->load->controller('common/language');
		$data['currency'] = $this->load->controller('common/currency');
		$data['search'] = $this->load->controller('common/search');
		$data['cart'] = $this->load->controller('common/cart');
		$data['menu'] = $this->load->controller('common/menu');


		/* NeoSeo Firestore BEGIN */
		$current_theme = trim($this->config->get('config_theme'));
		$data['text_register'] = $this->language->get('text_register');
		$data['text_login'] = $this->language->get('text_login');
		$data['text_forgotten'] = $this->language->get('text_forgotten');
		$data['text_enter'] = $this->language->get('text_enter');
		$data['text_password'] = $this->language->get('text_password');
		$this->load->model('tool/neoseo_firestore_tools');
		$this->model_tool_neoseo_firestore_tools->processHeader();
		$data['scripts'] = $this->model_tool_neoseo_firestore_tools->getHeaderScripts();
		$data['styles'] = $this->model_tool_neoseo_firestore_tools->getHeaderStyles();
		if(!isset($data['total_wishlist'] )) $data['total_wishlist'] = 0;
		/* NeoSeo Firestore END */
		return $this->load->view('common/header', $data);
	}
}
