<?php

require_once( DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerExtensionModuleNeoSeoSubscribe extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName = "neoseo_subscribe";
		$this->_modulePostfix = ""; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	protected function log($message)
	{
		file_put_contents(DIR_LOGS . $this->config->get("config_error_filename"), date("Y-m-d H:i:s - ") . "NeoSeo CallMe " . $message . "\r\n", FILE_APPEND);
	}

	public function index($setting)
	{

		static $module = 0;

		$data = $this->load->language("extension/module/" . $this->_moduleSysName());
		$this->document->addScript('catalog/view/javascript/' . $this->_moduleSysName() . '.js');
		$data['banners'] = array();

		//Определяем язык заголовка
		$language_id = $this->config->get('config_language_id');
		$title = $this->config->get($this->_moduleSysName() . "_title");
		$data['text_title'] = html_entity_decode(isset($title[$language_id]) ? $title[$language_id] : '');
		$data['module'] = $module++;
		$data['show_name'] = $this->config->get($this->_moduleSysName() . "_show_name");

		return $this->load->view('extension/module/' . $this->_moduleSysName() . '_start', $data);
	}

	public function process()
	{
		$json = array();

		$data = $this->load->language("extension/module/" . $this->_moduleSysName());

		if (!isset($this->request->post['subscribe'])) {
			$data['message'] = $this->language->get('text_empty');
			$data['heading_title'] = $this->language->get('error_exist');
			$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);
			return $this->response->setOutput(json_encode($json));
		}
		$show_name = $this->config->get($this->_moduleSysName() . "_show_name");

		$email = trim($this->request->post['subscribe']);
		if ($show_name) {
			$name = $this->request->post['subscribe_name'];
		} else {
			$name = '';
		}
		if (empty($email)) {
			$data['message'] = $this->language->get('text_empty');
			$data['heading_title'] = $this->language->get('error_exist');
			$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);
			return $this->response->setOutput(json_encode($json));
		}
		if ($show_name) {
			if (utf8_strlen($name) > 96 || utf8_strlen($name) < 2) {
				$data['message'] = $this->language->get('text_name');
				$data['heading_title'] = $this->language->get('error_exist');
				$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);
				return $this->response->setOutput(json_encode($json));
			}
		}
		if ((utf8_strlen($email) > 96) || (!preg_match("/^[^@]+@.*.[a-z]{2,15}$/i", $email))) {
			$data['message'] = $this->language->get('text_wrong');
			$data['heading_title'] = $this->language->get('error_exist');
			$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);
			return $this->response->setOutput(json_encode($json));
		}

		//Определяем язык сообщения
		$this->load->model('localisation/language');
		$language_id = $this->config->get('config_language_id');

		$this->load->model("extension/module/" . $this->_moduleSysName());

		if ($this->model_extension_module_neoseo_subscribe->existEmail($email)) {
			$message = $this->config->get($this->_moduleSysName() . '_message_error');
			$data['message'] = html_entity_decode($message[$this->config->get('config_language_id')]);
			$data['heading_title'] = $this->language->get('error_exist');
			$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);
			return $this->response->setOutput(json_encode($json));
		}

		$subscribe_id = $this->model_extension_module_neoseo_subscribe->add($email, $name);

		$message = $this->config->get($this->_moduleSysName() . '_message');

		$data['message'] = html_entity_decode(str_replace(array("{subscribe_id}", "{email}", "{name}"), array($subscribe_id, $email, $name), $message[$language_id]));

		$mail = new Mail();
		$mail->protocol = $this->config->get('config_mail_protocol');
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
		$mail->smtp_username = $this->config->get('config_mail_smtp_username');
		$mail->smtp_password = $this->config->get('config_mail_smtp_password');
		$mail->smtp_port = $this->config->get('config_mail_smtp_port');
		$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender($this->config->get('config_email'));

		$notify_subject = str_replace(array("{subscribe_id}", "{email}", "{name}"), array($subscribe_id, $email, $name), $this->config->get($this->_moduleSysName() . "_notify_subject"));
		$mail->setSubject($notify_subject);
		$notify_message = html_entity_decode(str_replace(array("{subscribe_id}", "{email}", "{name}"), array($subscribe_id, $email, $name), $this->config->get($this->_moduleSysName() . "_notify_message")));
		$mail->setHTML($notify_message);

		foreach (explode(",", $this->config->get($this->_moduleSysName() . "_notify_list")) as $notify_email) {
			$notify_email = trim($notify_email);
			if (!$notify_email)
				continue;
			$mail->setTo($notify_email);
			$mail->send();
		}

		$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName() . '_finish', $data);

		$this->response->setOutput(json_encode($json));
	}

}
