<?php

require_once(DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerExtensionModuleNeoSeoFilterTag extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName = "neoseo_filter";
		$this->_modulePostfix = "_tag"; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName . ".log";
		$this->debug = $this->config->get($this->_moduleSysName . "_debug");
	}

	public function index($setting)
	{
		static $module = 1;

		if (isset($this->request->get['route']) && $this->request->get['route']) {
			$route = str_replace('/', '_', $this->request->get['route']);
		} else {
			$route = 'common_home';
		}

		if ($setting['status'] != 1) {
			$this->log('route ' . $route . 'Модуль отключен и не может быть выведенным на страницу.');
			return false;
		}

		$module_type = isset($setting['type']) ? $setting['type'] : 'filter_pages';

		$data = $this->load->language('extension/module/' . $this->_moduleSysName());

		$language_id = $this->config->get('config_language_id');

		$limit = $setting['limit'] ? $setting['limit'] : 20;

		if ($module_type == 'filter_pages') {

			if (!isset($this->request->get['path'])) {
				$this->log("route $route. Тип модуля $module_type, но он выведен не на странице категории");
				return false;
			}

			$path = $this->request->get['path'];
			$parts = explode('_', (string) $path);
			$category_id = (int) array_pop($parts);

			$page_type = !isset($this->request->get['nsf']) ? 'category' : 'filter_page';

			if ($page_type == 'category') {
				$key = $module_type . '_' . $module . '_category_id' . $category_id;
			} else {
				$key = $module_type . '_' . $module . '_filter_page' . $category_id . '_' . $this->request->get['nsf'];
			}
		} elseif ($module_type == 'hand') {
			$key = $module_type . '_' . $module;
		}

		$cache_key = $this->_moduleSysName . '_' . $route . '_' . $key . '_' . $language_id;

		$data['tags'] = $this->cache->get($cache_key);

		if (!$data['tags']) {
			$this->load->model('extension/module/' . $this->_moduleSysName());

			if ($module_type == 'filter_pages') {
				if ($page_type == 'category') {
					$tags = $this->model_extension_module_neoseo_filter_tag->getTag($category_id, $limit);
				} else {
					$tags = $this->model_extension_module_neoseo_filter_tag->getFilterPageTag($this->request->get['nsf'], $category_id, $limit);
				}
			} elseif ($module_type == 'hand') {
				$page_ids = isset($setting['filter_pages']) ? $setting['filter_pages'] : array();
				$tags = $this->model_extension_module_neoseo_filter_tag->getFilterPage($page_ids);
			}

			if (!$tags) {
				$this->log("route $route. Нет доступных тегов для вывода");
				return false;
			}

			$data['tags'] = array();
			foreach ($tags as $tag) {
				if (!trim($tag['options'])) {
					$this->log("route $route. Посадочная не содержит выбранных опций фильтра. ");
					continue;
				}

				$url = $this->url->link('product/category', 'path=' . $tag['category_id'] . '&nsf=' . $tag['options']);

				$data['tags'][] = array(
					'name' => $tag['tag_name'],
					'url' => $url,
				);
			}

			if (!$data['tags']) {
				$this->log("route $route. Нет доступных тегов для вывода");
				return false;
			}

			$this->cache->set($cache_key, $data['tags']);
		}

		$data['heading_title'] = '';
		if (isset($setting['title'][$language_id])) {
			$data['heading_title'] = $setting['title'][$language_id];
		}

		$this->document->addScript('catalog/view/javascript/showMore.js');

		$data['module'] = $module++;

		return $this->load->view('extension/module/' . $this->_moduleSysName(), $data);
	}

}
