<?php
/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
*/

/**
* Config class
*/
class Config {
	private $data = array();

	/* NeoSeo Firestore BEGIN */
	private $is_mobile = false;
	private $mobile_detected = false;
	/* NeoSeo Firestore END */
	
    
	/**
     * 
     *
     * @param	string	$key
	 * 
	 * @return	mixed
     */

	/* NeoSeo Firestore BEGIN */
	public function is_mobile()
	{
		if(!$this->mobile_detected){
			require_once DIR_SYSTEM . 'library/mobile_detect.php';
			$mobile_Detect = new Mobile_Detect();
			$this->is_mobile = $mobile_Detect->isMobile();
			$this->mobile_detected = true;
		}
		return $this->is_mobile;
	}
	/* NeoSeo Firestore END */
	
	public function get($key) {
		return (isset($this->data[$key]) ? $this->data[$key] : null);
	}
	
    /**
     * 
     *
     * @param	string	$key
	 * @param	string	$value
     */
	public function set($key, $value) {
		$this->data[$key] = $value;
	}

    /**
     * 
     *
     * @param	string	$key
	 *
	 * @return	mixed
     */
	public function has($key) {
		return isset($this->data[$key]);
	}
	
    /**
     * 
     *
     * @param	string	$filename
     */
	public function load($filename) {
		$file = DIR_CONFIG . $filename . '.php';

		if (file_exists($file)) {
			$_ = array();

			require(modification($file));

			$this->data = array_merge($this->data, $_);
		} else {
			trigger_error('Error: Could not load config ' . $filename . '!');
			exit();
		}
	}
}