<?php
class ControllerCommonMenu extends Controller {
	public function index() {
		$this->load->language('common/menu');

		// Menu
		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$data['categories'] = array();


/* NeoSeo Firestore BEGIN */
        $current_theme = trim($this->config->get('config_theme'));
		$menu_status = $this->config->get('theme_' . $current_theme . '_menu');

		if ($menu_status) {
		    $data['menu_type']          = $this->config->get('theme_' . $current_theme . '_main_menu_type');
		    $data['menu_items_count']   = $this->config->get('theme_' . $current_theme . '_main_menu_items_count');
		    $data['menu_column_count']  = $this->config->get('theme_' . $current_theme . '_main_menu_column_count');
			$data['categories']         = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_menu_id'));
		} else {
/* NeoSeo Firestore END */
                    
		$categories = $this->model_catalog_category->getCategories(0);

		foreach ($categories as $category) {
			if ($category['top']) {
				// Level 2
				$children_data = array();

				$children = $this->model_catalog_category->getCategories($category['category_id']);

				foreach ($children as $child) {
					$filter_data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);

					$children_data[] = array(
						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])
					);
				}

				// Level 1
				$data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])
				);
			}
		}


/* NeoSeo Firestore BEGIN */
		}
		$data['menu_button_title'] = $this->config->get('theme_' . trim($this->config->get('config_theme')) . '_menu_button_title');
		$data['menu_button_title'] = $data['menu_button_title'][(int)$this->config->get('config_language_id')];
/* NeoSeo Firestore END */
		return $this->load->view('common/menu', $data);
	}
}
