<?php
class ControllerCommonFooter extends Controller {
	public function index() {
		$this->load->language('common/footer');

		$this->load->model('catalog/information');

		$data['informations'] = array();

		/* NeoSeo Firestore BEGIN */
		$this->load->model('extension/module/neoseo_menu');
        $current_theme = trim($this->config->get('config_theme'));
		$menu_status = $this->config->get('theme_' . $current_theme . '_menu');

		if ($menu_status) {
			$data['menu_catalog']   = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_footer_menu_catalog'));
			$data['menu_info']      = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_footer_menu_info'));
			$data['menu_contacts']  = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_footer_menu_contacts'));
			$data['menu_offer']     = $this->model_extension_module_neoseo_menu->getMenu(0, $this->config->get('theme_' . $current_theme . '_footer_menu_offer'));
		}

		$data['facebook']   = $this->config->get('theme_' . $current_theme . '_footer_facebook');
		$data['instagram']  = $this->config->get('theme_' . $current_theme . '_footer_instagram');
		$data['telegram']   = $this->config->get('theme_' . $current_theme . '_footer_telegram');
		$data['whatsapp']   = $this->config->get('theme_' . $current_theme . '_footer_whatsapp');
		$data['phone']      = $this->config->get('theme_' . $current_theme . '_top_phone_1');
		$data['worktime']   = $this->config->get('theme_' . $current_theme . '_footer_worktime');
		$data['worktime']   = $data['worktime'][(int)$this->config->get('config_language_id')];
		$data['email']      = $this->config->get('config_email');
		$data['address']    = $this->config->get('theme_' . $current_theme . '_footer_address');
		$data['address'] = $data['address'][(int)$this->config->get('config_language_id')];
		$data['copywrite'] = $this->config->get('theme_' . $current_theme . '_footer_copywrite');
		$data['copywrite'] = html_entity_decode($data['copywrite'][(int)$this->config->get('config_language_id')]);

		$this->load->model('account/wishlist');
		$data['wishlist_data'] = $this->model_account_wishlist->getPreparedWishlist();
		if (!isset($this->session->data['compare'])) {
			$data['compare_data'] = array();
		} else {
			$data['compare_data'] = $this->session->data['compare'];
		}

		/* NeoSeo Firestore END */

		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
		}

		/* NeoSeo Smart Search - begin */
		if ($this->config->get("neoseo_smart_search_status") == 1) {
		    $data['neoseo_smart_search_status'] = $this->config->get("neoseo_smart_search_status");
		    $data['neoseo_smart_search_selector'] = $this->config->get("neoseo_smart_search_selector");
		}
		/* NeoSeo Smart Search - end */
		$data['contact'] = $this->url->link('information/contact');
		$data['return'] = $this->url->link('account/return/add', '', true);
		$data['sitemap'] = $this->url->link('information/sitemap');
		$data['tracking'] = $this->url->link('information/tracking');
		$data['manufacturer'] = $this->url->link('product/manufacturer');
		$data['voucher'] = $this->url->link('account/voucher', '', true);
		$data['affiliate'] = $this->url->link('affiliate/login', '', true);
		$data['special'] = $this->url->link('product/special');
		$data['account'] = $this->url->link('account/account', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);

		$data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('config_name'), date('Y', time()));

		// Whos Online
		if ($this->config->get('config_customer_online')) {
			$this->load->model('tool/online');

			if (isset($this->request->server['REMOTE_ADDR'])) {
				$ip = $this->request->server['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
				$url = ($this->request->server['HTTPS'] ? 'https://' : 'http://') . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
			} else {
				$url = '';
			}

			if (isset($this->request->server['HTTP_REFERER'])) {
				$referer = $this->request->server['HTTP_REFERER'];
			} else {
				$referer = '';
			}

			$this->model_tool_online->addOnline($ip, $this->customer->getId(), $url, $referer);
		}

		$data['scripts'] = $this->document->getScripts('footer');
		$data['styles'] = $this->document->getStyles('footer');
		
		return $this->load->view('common/footer', $data);
	}
}
