<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="submit" form="form-html" data-toggle="tooltip" title="<?php echo $button_save; ?>"
                        class="btn btn-primary"><i class="fa fa-save"></i></button>
                <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>"
                   class="btn btn-default"><i class="fa fa-reply"></i></a></div>
            <h1><?php echo $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
            </div>
            <div class="panel-body">

                <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-html"
                      class="form-horizontal">   <!-------------- FORM START ---------------->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-name"><?php echo $entry_name; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="name" value="<?php echo $name; ?>" required minlength="3"
                                   placeholder="<?php echo $entry_name; ?>" id="input-name" class="form-control"/>
                            <?php if ($error_name) { ?>
                            <div class="text-danger"><?php echo $error_name; ?></div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
                        <div class="col-sm-10">
                            <select name="status" id="input-status" class="form-control">
                                <?php if ($status) { ?>
                                <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                                <option value="0"><?php echo $text_disabled; ?></option>
                                <?php } else { ?>
                                <option value="1"><?php echo $text_enabled; ?></option>
                                <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <ul class="nav nav-tabs" id="slides">  <!------------- SLIDES --------------------->
                        <?php foreach ($slides as $slide) { ?>
                        <li><a href="#tab-<?php echo $slide->name; ?>" data-toggle="tab"><?php echo $slide->heading;
                                ?></a></li>
                        <?php } ?>
                    </ul>
                    <div class="tab-content">
                        <?php foreach ($slides as $slide) { ?>
                        <div class="tab-pane" id="tab-<?php echo $slide->name; ?>">


                            <ul class="nav nav-tabs languages-tabs">
                                <?php foreach ($languages as $language) { ?>
                                <li>
                                    <a href="#language<?php echo $language['language_id']; ?>-<?php echo $slide->name; ?>"
                                       data-toggle="tab"><img
                                                src="view/image/flags/<?php echo $language['image']; ?>"
                                                title="<?php echo $language['name']; ?>"/> <?php echo $language['name']; ?>
                                    </a></li>
                                <?php } ?>
                            </ul>
                            <div class="tab-content">
                                <?php foreach ($languages as $language) { ?>
                                <div class="tab-pane"
                                     id="language<?php echo $language['language_id']; ?>-<?php echo $slide->name; ?>">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label"
                                               for="input-<?php echo $slide->name.'-'.$language['language_id']; ?>"><?php echo $entry_image; ?></label>
                                        <div class="col-sm-10">
      <a href="" id="thumb-<?php echo $slide->name.'-'.$language['language_id']; ?>" data-toggle="image" class="img-thumbnail">
      <img src="<?php echo $slide->imagesThumbs[$language['code']];?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>"/></a>
                                            <input type="hidden" name="<?php echo $slide->imagesEntries[$language['code']]; ?>"  value="<?php echo $slide->images[$language['code']]; ?>" id="input-<?php echo $slide->name.'-'.$language['language_id']; ?>"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label"
                                               for="input-<?php echo $slide->titlesEntries[$language['code']]; ?>"><?php echo $entry_title; ?></label>
                                        <div class="col-sm-10">
                                            <input type="text"
                                                   name="<?php echo $slide->titlesEntries[$language['code']]; ?>"
                                                   placeholder="<?php echo $entry_title; ?>"
                                                   id="input-heading<?php echo $language['language_id']; ?>"
                                                   value="<?php echo $slide->titles[$language['code']]; ?>"
                                                   class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label"
                                               for="input-<?php echo $slide->buttonTitlesEntries[$language['code']]; ?>"><?php echo $entry_button_title; ?></label>
                                        <div class="col-sm-10">
                                            <input type="text"
                                                   name="<?php echo $slide->buttonTitlesEntries[$language['code']]; ?>"
                                                   placeholder="<?php echo $entry_button_title; ?>"
                                                   id="input-button-title<?php echo $language['language_id']; ?>"
                                                   value="<?php echo $slide->buttonTitles[$language['code']]; ?>"
                                                   class="form-control"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label"
                                               for="input-<?php echo $slide->buttonLinksEntries[$language['code']]; ?>"><?php echo $entry_button_link; ?></label>
                                        <div class="col-sm-10">
                                            <input type="text"
                                                   name="<?php echo $slide->buttonLinksEntries[$language['code']]; ?>"
                                                   placeholder="<?php echo $entry_button_link; ?>"
                                                   id="input-button-link<?php echo $language['language_id']; ?>"
                                                   value="<?php echo $slide->buttonLinks[$language['code']]; ?>"
                                                   class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $('.languages-tabs').each(function () {
            $(this).find('a:first').tab('show');
        });
        $('#slides a:first').tab('show');
        </script>
</div>
<?php echo $footer; ?>